package gov.va.vamf.scheduling.varutility.resource;

import gov.va.vamf.scheduling.varutility.domain.CustomMessage;
import gov.va.vamf.scheduling.varutility.domain.CustomMessages;
import gov.va.vamf.scheduling.varutility.service.CustomMessageService;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;

import java.util.Iterator;

@Component
@Path("/custom-messages")
@Scope("request")
public class CustomMessageResource implements InitializingBean {

    @Value("${default.messages.id}")
    String defaultMessagesId;

    @Value("${default.messages.text}")
    String defaultMessagesText;

    private String[] defaultMessageIds;
    private String[] defaultMessageTexts;

    @Autowired
    private CustomMessageService customMessageService;

    @Override
    public void afterPropertiesSet() throws Exception {
        defaultMessageIds = defaultMessagesId.split("\\|");
        defaultMessageTexts = defaultMessagesText.split("\\|");
    }

    @GET
    @Path("/default-message/message-id/{message-id}")
    @Produces({MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON})
    public CustomMessage fetchDefaultMessage(@PathParam("message-id") String messageId) {

        CustomMessage defaultMessage = new CustomMessage();

        if (messageId != null) {
            for (int i = 0; i < defaultMessageIds.length; i++) {
                if (messageId.equals(defaultMessageIds[i])) {
                    defaultMessage.setMessageId(defaultMessageIds[i]);
                    defaultMessage.setMessageText(defaultMessageTexts[i]);
                    break;
                }
            }
        }

        return defaultMessage;
    }

    @GET
    @Path("/site/{site-code}")
    @Produces({MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON})
    public CustomMessages fetchCustomMessages(@PathParam("site-code") String siteCode) {

        CustomMessages customMessages = customMessageService.fetchCustomMessagesBySiteCode(siteCode);

        if (customMessages == null) {
            customMessages = new CustomMessages();
        }

        for (int i = 0; i < defaultMessageIds.length; i++) {
            if (!containsMessageId(defaultMessageIds[i], customMessages)) {

                CustomMessage defaultMessage = new CustomMessage();
                defaultMessage.setSiteCode(siteCode);
                defaultMessage.setMessageId(defaultMessageIds[i]);
                defaultMessage.setMessageText(defaultMessageTexts[i]);

                CustomMessage savedDefaultMessage = customMessageService.saveCustomMessage(defaultMessage);

                if (savedDefaultMessage != null)  {
                    customMessages.add(savedDefaultMessage);
                }
            }
        }

        return customMessages;
    }

    @PUT
    @Path("/site/{site-code}")
    @Produces({MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON})
    @Consumes({MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON})
    public CustomMessages saveCustomMessages(CustomMessages customMessages,
                                             @PathParam("site-code") String siteCode) {

        CustomMessages savedCustomMessages = new CustomMessages();

        CustomMessage foundCustomMessage = null;
        CustomMessage newCustomMessage = null;
        CustomMessage savedCustomMessage = null;

        Iterator<CustomMessage> customMessagesIterator = customMessages.iterator();

        while (customMessagesIterator.hasNext()) {
            newCustomMessage = customMessagesIterator.next();

            foundCustomMessage = customMessageService.fetchCustomMessageBySiteCodeAndMessageId(siteCode, newCustomMessage.getMessageId());

            if (foundCustomMessage != null && foundCustomMessage.getId() != null) {
                newCustomMessage.setId(foundCustomMessage.getId());
            }

            newCustomMessage.setSiteCode(siteCode);
            savedCustomMessage = customMessageService.saveCustomMessage(newCustomMessage);

            if (savedCustomMessage != null) {
                savedCustomMessages.add(savedCustomMessage);
            }
        }

        return savedCustomMessages;
    }

    @DELETE
    @Path("/site/{site-code}")
    @Produces({MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON})
    public CustomMessages deleteCustomMessages(@PathParam("site-code") String siteCode) {

        CustomMessages customMessages = customMessageService.deleteCustomMessagesBySiteCode(siteCode);

        if (customMessages == null) {
            customMessages = new CustomMessages();
        }

        return customMessages;
    }

    private boolean containsMessageId(String messageId, CustomMessages customMessages) {
        Iterator<CustomMessage> customMessagesIterator = customMessages.iterator();

        while (customMessagesIterator.hasNext()) {
            if (messageId.equals(customMessagesIterator.next().getMessageId())) {
                return true;
            }
        }

        return false;
    }
}
